import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.BootPartitionHeader import BootPartitionHeader
from cse_image_items.SubPartitionDirectoryDescriptor import SubPartitionDirectoryDescriptor
from cse_image_items.SubPartitionDirectory import SubPartitionDirectory


logger = logging.getLogger(__name__)

class BootPartition(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START BootPartition.__init__ FUNCTION')
        
        super(BootPartition, self).__init__(data, **kwargs)
        self.header = BootPartitionHeader(self.value, **kwargs['header'])
        self.set_sub_partition_directory_descriptors(kwargs['sub_partition_directory_descriptor'])
        self.set_sub_partition_directory_entries(kwargs['sub_partition_directory'])

    def set_sub_partition_directory_descriptors(self, subPartitionDirectoryDescriptor):
        self.sub_partition_directory_descriptors = []
        sub_partition_directory_descriptor_start_offset = self.header.size
        number_of_sub_partition_directory_descriptors = self.header.descriptor_count.int_value()
        for _ in xrange(number_of_sub_partition_directory_descriptors):
            subPartitionDirectoryDescriptor['offset'] = hex(
                sub_partition_directory_descriptor_start_offset).decode()
            sub_partition_directory_descriptor = SubPartitionDirectoryDescriptor(
                self.value, **subPartitionDirectoryDescriptor)
            self.sub_partition_directory_descriptors.append(sub_partition_directory_descriptor)
            sub_partition_directory_descriptor_start_offset += sub_partition_directory_descriptor.size

    def set_sub_partition_directory_entries(self, sub_partition_directory):
        self.sub_partition_directory_entries = []
        for entry in self.sub_partition_directory_descriptors:
            # check if sub partition is in use
            if entry.sub_partition_offset.int_value() == 0:
                continue
            if entry.type == 'CSE_BUP':
                sub_partition_directory['offset'] = entry.sub_partition_offset.hex_value()
                sub_partition_directory['size'] = entry.sub_partition_size.hex_value()
                entry = SubPartitionDirectory(
                    self.value,
                    entry_type=entry.type,
                    **sub_partition_directory
                )
                self.sub_partition_directory_entries.append(entry)
